% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corClasses.R
\name{corARMA}
\alias{corARMA}
\title{ARMA(p,q) Correlation Structure}
\usage{
corARMA(value, form, p, q, fixed)
}
\arguments{
\item{value}{numeric vector of parameter values}

\item{form}{a one-sided formula of the form \code{~ t}, \code{~ 1 | g}, or \code{~ t | g},
specifying a time covariate \code{t}, a grouping factor \code{g}, or both.
When no time covariate is specified, the row order of the data within each group is assumed to
represent the chronological order of measurements.}

\item{p}{non-negative integer specifying the autoregressive order}

\item{q}{non-negative integer specifying the moving average order}

\item{fixed}{unused}
}
\description{
Re-exports \link[nlme:corARMA]{nlme::corARMA} from the \pkg{nlme} package.
}
\details{
In the original \link[nlme:corARMA]{nlme::corARMA} function, a covariate \code{t} must be an integer class.
In \pkg{pwr4exp}, \code{t} can also be a factor class, which is then converted to an integer internally for chronological order.
The class of \code{t} in the model formula, if present, is not converted. For example, a time covariate can be fitted as a factor
in the model formula, whereas it is converted to an integer in the correlation formula.
}
\seealso{
\link{corClasses}
See \link[nlme:corARMA]{nlme::corARMA} for original documentation.
}
