% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{qad}
\alias{qad}
\alias{qad.data.frame}
\alias{qad.numeric}
\title{Measure of (asymmetric and directed) dependence}
\usage{
qad(x, ...)

\method{qad}{data.frame}(
  x,
  resolution = NULL,
  p.value = TRUE,
  nperm = 1000,
  p.value_asymmetry = FALSE,
  nboot = 1000,
  print = TRUE,
  remove.00 = FALSE,
  ...
)

\method{qad}{numeric}(
  x,
  y,
  resolution = NULL,
  p.value = TRUE,
  nperm = 1000,
  p.value_asymmetry = FALSE,
  nboot = 1000,
  print = TRUE,
  remove.00 = FALSE,
  ...
)
}
\arguments{
\item{x}{a data.frame containing two columns with the observations of the bi-variate sample or a (non-empty) numeric vector of data values}

\item{...}{Further arguments passed to 'qad' will be ignored}

\item{resolution}{an integer indicating the number of strips for the checkerboard aggregation (see \link{ECBC}). We recommend to use the default value (resolution = NULL)}

\item{p.value}{a logical indicating whether to return a p-value of rejecting independence (based on permutation).}

\item{nperm}{an integer indicating the number of permutation runs (if p.value = TRUE)}

\item{p.value_asymmetry}{a logical indicating whether to return a (heuristic) p-value for the measure of asymmetry (based on bootstrap).}

\item{nboot}{an integer indicating the number of runs for the bootstrap.}

\item{print}{a logical indicating whether the result of qad is printed.}

\item{remove.00}{a logical indicating whether double 0 entries should be excluded (default = FALSE)}

\item{y}{a (non-empty) numeric vector of data values.}
}
\value{
qad returns an object of class qad containing the following components:
\item{data}{ a data.frame containing the input data.}
\item{q(X,Y)}{influence of X on Y}
\item{q(Y,X)}{influence of Y on X}
\item{max.dependence}{maximal dependence}
\item{results}{ a data.frame containing the results of the dependence measures.}
\item{mass_matrix}{ a matrix containing the mass distribution of the empirical checkerboard copula.}
\item{resolution}{an integer containing the used resolution of the checkerboard aggregation.}
\item{n}{Sample size.}
}
\description{
Quantification of (asymmetric and directed) dependence structures between two random variables X and Y.
}
\details{
qad is the implementation of a strongly consistent estimator of the copula based dependence measure zeta_1 introduced in Trutschnig 2011.
We first compute the empirical copula of a two-dimensional sample, aggregate it to the so called empirical checkerboard copula (ECBC), and
calculate zeta_1 of the ECBC and its transpose. In order to test for independence (in both directions), a built-in p-value
is implemented (a permutation test with nperm permutation runs to estimate the p-value).
Furthermore, a (heuristic) bootstrap test with nboot runs can be applied to estimate a p-value for the measure of asymmetry a.
}
\examples{
#Example 1 (independence)

n <- 100
x <- runif(n,0,1)
y <- runif(n,0,1)
sample <- data.frame(x,y)
qad(sample)

###

#Example 2 (mutual complete dependence)

n <- 500
x <- runif(n,0,1)
y <- x^2
sample <- data.frame(x,y)
qad(sample)

#Example 3 (complete dependence)

n <- 1000
x <- runif(n,-10,10)
y <- sin(x)
sample <- data.frame(x,y)
qad(sample)

#Example 4 (Asymmetry)

n <- 100
x <- runif(n,0,1)
y <- (2*x) \%\% 1
qad(x, y)
}
\references{
Trutschnig, W. (2011). On a strong metric on the space of copulas and its induced dependence measure, Journal of Mathematical Analysis and Applications 384, 690-705.

Junker, R., Griessenberger, F. and Trutschnig, W. (2021). Estimating scale-invariant directed dependence of bivariate distributions.  Computational Statistics and Data Analysis, 153.
}
\seealso{
A tutorial can be found at \url{http://www.trutschnig.net/software.html}.
}
