% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npcrs2.R
\name{npcrs2}
\alias{npcrs2}
\alias{npcrs2.default}
\title{Attributes Control Charts under Repetitive Sampling with two positive integers}
\usage{
npcrs2(.n, .p0, .f, .ssize = NULL, .k1 = NULL, .k2 = NULL,
  .k1r = NULL, .k2r = NULL)

\method{npcrs2}{default}(.n, .p0, .f, .ssize = NULL, .k1 = NULL,
  .k2 = NULL, .k1r = NULL, .k2r = NULL)
}
\arguments{
\item{.n}{Sample Size}

\item{.p0}{probability that process is in control}

\item{.f}{Size of the Shift}

\item{.ssize}{Number of samples with replacement at each iteration}

\item{.k1}{Fixed positive constant}

\item{.k2}{Fixed positive constant}

\item{.k1r}{Random postive constant}

\item{.k2r}{Random postive constant}
}
\value{
ASN, ARL, K1 and K2
}
\description{
Calculates Average Sample Numbers (ASN), Average Run Length (ARL1) and value of k1 and k2 for attributes control charts under repetitive sampling as given in Aslam et al.(2014)
}
\examples{

library(magrittr)
 npcrs2(
  .n     = 40
, .p0    = 0.10
, .f     = 0.1
, .ssize = 1000
, .k1r   = 4
, .k2r   = .95
   )


npcrs2(
  .n     = 40
, .p0    = 0.10
, .f     = 0.1
, .k1    = 3.13
, .k2    = .731
   )




}
\references{
Aslam, M., Azam, M. and Jun, C. (2014).
 New Attributes and Variables Control Charts under Repetitive Sampling.
 \emph{Industrial Engineering & Management Systems}.
 \strong{13}(1):101-106.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Muhammad Aslam  (\email{aslam_ravian@hotmail.com})
         \item Sami Ullah      (\email{samiullahuos@gmail.com})
         \item Muhammad Azam   (\email{mazam@uvas.edu.pk})
         \item Chi-Hyuck Jun   (\email{chjun@postech.ac.kr})
         \item Muhammad Kashif (\email{mkashif@uaf.edu.pk})
         }
}
