% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\name{mv.filter}
\alias{mv.filter}
\title{Filtering variable based on the percentage of missing values}
\usage{
mv.filter(x, thres = 0.3)
}
\arguments{
\item{x}{a data matrix. The columns are features.}

\item{thres}{threshold of missing values. Features less than this
threshold will be kept. Value has to be between 0 and 1.}
}
\value{
a list of with contents: \itemize{
\item dat the filtered data matrix
\item idx a logical vector of index for keeping features.
}
}
\description{
This function calculates the percentage of missing values and keeps those
features with missing values percentage less than the designed threshold.
}
\examples{
names(man_qc)
data <- man_qc$data
meta <- man_qc$meta
## check missing value rates
tail(sort(mv.perc(data)), 20)
## missing values filtering
tmp <- mv.filter(data, thres = 0.15)
data_f <- tmp$dat
## compare
dim(data_f)
dim(data)
}
\seealso{
Other missing value processing: 
\code{\link{mv.filter.qc}()},
\code{\link{mv.perc}()}
}
\concept{missing value processing}
