% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\name{mv.filter.qc}
\alias{mv.filter.qc}
\title{Data filtering based on "qc" missing values}
\usage{
mv.filter.qc(x, y, thres = 0.3)
}
\arguments{
\item{x}{a data matrix.}

\item{y}{a character string with contents of "sample", "qc" and "blank".}

\item{thres}{threshold of missing values. Features less than this
threshold will be kept.}
}
\value{
a list of with contents: \itemize{
\item dat the filtered data matrix
\item idx a logical vector of index for keeping features.
}
}
\description{
Data filtering based on "qc" missing values
}
\examples{
names(man_qc)
data <- man_qc$data
meta <- man_qc$meta
## check missing value rates
tail(sort(mv.perc(data)), 20)
## missing values filtering based on QC
cls.qc <- factor(meta$sample_type)
tmp <- mv.filter.qc(data, cls.qc, thres = 0.15)
data_f <- tmp$dat
## compare
dim(data_f)
dim(data)
}
\seealso{
Other missing value processing: 
\code{\link{mv.filter}()},
\code{\link{mv.perc}()}
}
\concept{missing value processing}
