% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_boot_ss.R
\name{find_boot_ss}
\alias{find_boot_ss}
\title{Find realistic bootstrap sample sizes}
\usage{
find_boot_ss(pred_sigs, pred_diets, prey_sigs, prey_loc, n_pred_boot = 1000)
}
\arguments{
\item{pred_sigs}{A vector or matrix of predator signatures, intended to be
the object \code{pred_sigs} returned by a call to the function
\code{\link{est_diet}}.}

\item{pred_diets}{A numeric matrix of the estimated diet compositions of
individual predators, intended to be the object \code{est_ind} returned by
a call to \code{\link{est_diet}}.}

\item{prey_sigs}{A matrix of prey signatures, intended to be the object
\code{prey_sigs} returned by a call to the function \code{\link{est_diet}}.}

\item{prey_loc}{A matrix giving the first and last locations of the
signatures of each prey type within \code{prey_sigs}, intended to be the
object \code{loc} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame, or by a call to the
function \code{\link{make_prey_part}} if a partitioned prey library was
used for diet estimation.}

\item{n_pred_boot}{An integer designating the number of predator signatures
to bootstrap. See Details. Default value 1000.}
}
\value{
A list containing the following elements: \describe{
  \item{var_diet}{A numeric vector of the variance between the estimated
  diets of all possible pairs of predators, sorted in increasing order.}
  \item{var_sig}{A numeric vector of the variance between the signatures
  of all possible pairs of predators, sorted consistently with
  \code{var_diet}}.
  \item{var_sig_smooth}{A loess-smoothed version of var_sig.}
  \item{mod_sig_var}{A numeric vector of the modeled variance between
  bootstrapped predator signatures at each iteration of the algorithm.}
  \item{var_target}{The target level of variance between bootstrapped
  predator signatures.}
  \item{boot_ss}{An integer vector of bootstrap sample sizes for each prey
  type.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string containing a brief summary of the results.}
}
}
\description{
In QFASA simulation studies, predator signatures are often simulated by
bootstrap resampling prey signature data. \code{\link{find_boot_ss}} finds
bootstrap sample sizes for each prey type that produce simulated predator
signatures with realistic levels of variation.
}
\section{Details}{

QFASA simulation studies may require the generation of predator signatures
given a specified diet, against which estimates of diet composition can then
be compared (e.g., Bromaghin et al. 2015). Given a specified diet, a
bootstrap sample of each prey type is drawn and mean prey-type signatures
are computed.  A predator signature is then generated by multiplying the mean
bootstrapped prey signatures by the diet proportions.

Although authors often fail to report the bootstrap sample sizes used for
each prey type when describing simulations (e.g., Haynes et al. 2015;
Thiemann et al. 2008; Wang et al. 2010), they are subjectively selected
(e.g., Iverson et al. 2004; Bromaghin et al. 2015). However, Bromaghin et al.
(2016) found that bootstrap sample sizes strongly influence both the bias and
the variance of diet composition estimates in simulation studies.
Consequently, the selection of bootstrap sample sizes is an important aspect
of simulation design.

Bromaghin (2015) presented an objective method of establishing a bootstrap
sample size for each prey type that produces simulated predator signatures
having a realistic level of between-signature variation.  The function
\code{\link{find_boot_ss}} implements the algorithm of Bromaghin (2015). A
brief summary of the algorithm, sufficient to understand the objects returned
by \code{find_boot_ss}, follows below. Please refer to Bromaghin (2015) for
additional details.

The concept underlying the algorithm is that the variation in predator
signatures can be partitioned into variation due to differences in diet and
variation due to prey animals consumed given diet. Consequently, a realistic
level of variation between signatures for predators sharing the same diet is
approximated from the empirical relationship between a measure of variation
between pairs of predator signatures \code{var_sig} and a measure of
variation between the estimated diets \code{var_diets} of the same predator
pairs. As the variance in diets approaches zero, the predators are
effectively eating the same diet and variation in their signatures therefore
approaches the level of variation due to prey selection only.
\code{\link{find_boot_ss}} models the relationship between \code{var_diet}
and \code{var_sig} using a loess smooth, and the modeled signature variance
\code{var_sig_smooth} for the pair of predators whose value of
\code{var_diet} is smallest is taken as the target level of variation for
predator signatures.

The algorithm is initialized with a sample size of 1 from each prey type.
A sample of \code{n_pred_boot} predator signatures is generated using those
sample sizes and the measure of variance among the signatures is computed.
If the variance measure exceeds the target level, the prey type contributing
most to the variance measure is identified and its sample size is increased
by 1. The algorithm then iterates, increasing the sample size by one at each
iteration, until the measure of variation is less than the target level. The
level of variation at each iteration and the target level of variation are
returned in the objects \code{mod_sig_var} and \code{var_terget},
respectively.

The argument \code{n_boot_pred} should be large enough to return an estimate
of the variance measure that itself has low variance, so that the algorithm
returns numerically stable results. We suspect that the default value of 1000
errs on the side of caution.

NOTE: Because \code{find_boot_ss} is intended to operate on the predator and
prey signatures returned by a call to the function \code{\link{est_diet}},
\code{find_boot_ss} can be based on diet estimates obtained in either the
predator or prey space, using an original or partitioned prey library.
However, it is imperative that the arguments are compatible.
}

\section{References}{

Bromaghin, J.F. 2015. Simulating realistic predator signatures in
  quantitative fatty acid signature analysis. \emph{Ecological Informatics}
  30:68-71.

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty acid
  signature proportions sum to 1 for diet estimation? \emph{Ecological
  Research} 31:597-606.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.

Haynes, T.B., J.A. Schmutz, J.F. Bromaghin, S.J. Iverson, V.M. Padula, and
  A.E. Rosenberger. 2015. Diet of yellow-billed loons (\emph{Gavia adamsii})
  in Arctic lakes during the nesting season inferred from fatty acid
  analysis. \emph{Polar Biology} 38:1239-1247.

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Thiemann, G.W., S.J. Iverson, and I. Stirling. 2008. Polar bear diets and
  Arctic marine food webs: insights from fatty acid analysis.
  \emph{Ecological Monographs} 78:591-613.

Wang, S.W., T.E. Hollmen, and S.J. Iverson. 2010. Validating quantitative
  fatty acid signature analysis to estimate diets of spectacled and Stellers
  eiders (\emph{Somateria fischeri} and \emph{Polysticta stelleri}).
  \emph{Journal of Comparative Physiology B} 180:125-139.
}

\examples{
find_boot_ss(pred_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                                  0.04, 0.11, 0.29, 0.56,
                                  0.10, 0.05, 0.35, 0.50,
                                  0.12, 0.03, 0.37, 0.48,
                                  0.10, 0.06, 0.35, 0.49,
                                  0.05, 0.15, 0.35, 0.45), ncol = 6),
             pred_diets = matrix(c(0.33, 0.34, 0.33,
                                   0.10, 0.80, 0.10,
                                   0.35, 0.50, 0.15,
                                   0.20, 0.35, 0.45,
                                   0.20, 0.45, 0.35,
                                   0.15, 0.65, 0.20), ncol = 6),
             prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                                  0.05, 0.09, 0.30, 0.56,
                                  0.03, 0.10, 0.30, 0.57,
                                  0.08, 0.07, 0.30, 0.55,
                                  0.09, 0.05, 0.33, 0.53,
                                  0.09, 0.06, 0.34, 0.51,
                                  0.09, 0.07, 0.34, 0.50,
                                  0.08, 0.11, 0.35, 0.46,
                                  0.06, 0.14, 0.36, 0.44), ncol = 9),
             prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2),
             n_pred_boot = 500)

find_boot_ss(pred_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                                  0.04, 0.11, 0.29, 0.56,
                                  0.10, 0.05, 0.35, 0.50,
                                  0.12, 0.03, 0.37, 0.48,
                                  0.10, 0.06, 0.35, 0.49,
                                  0.05, 0.15, 0.35, 0.45), ncol = 6),
             pred_diets = matrix(c(0.33, 0.34, 0.33,
                                   0.10, 0.80, 0.10,
                                   0.35, 0.50, 0.15,
                                   0.20, 0.35, 0.45,
                                   0.20, 0.45, 0.35,
                                   0.15, 0.65, 0.20), ncol = 6),
             prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                                  0.05, 0.09, 0.30, 0.56,
                                  0.03, 0.10, 0.30, 0.57,
                                  0.08, 0.07, 0.30, 0.55,
                                  0.09, 0.05, 0.33, 0.53,
                                  0.09, 0.06, 0.34, 0.51,
                                  0.09, 0.07, 0.34, 0.50,
                                  0.08, 0.11, 0.35, 0.46,
                                  0.06, 0.14, 0.36, 0.44), ncol = 9),
             prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2))

}
