% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_simhelpers.R
\name{simdata_quantized_emm}
\alias{simdata_quantized_emm}
\title{Simulate quantized exposures for testing methods}
\usage{
simdata_quantized_emm(
  outcometype = c("continuous", "logistic", "survival"),
  n = 100,
  corr = NULL,
  b0 = 0,
  mainterms = c(1, 0, 0, 0),
  prodterms = c(1, 0, 0, 0),
  ztype = "binary",
  q = 4,
  yscale = 1,
  shape0 = 3,
  scale0 = 5,
  censtime = 4,
  ncheck = TRUE,
  ...
)
}
\arguments{
\item{outcometype}{Character variable that is one of c("continuous", "logistic", "survival"). Selects what type of outcome should be simulated (or how). continuous = normal, continous outcome, logistic= binary outcome from logistic model, survival = right censored survival outcome from Weibull model.}

\item{n}{Sample size}

\item{corr}{NULL, or vector of correlations between the first exposure and subsequent exposures (if length(corr) < (length(coef)-1), then this will be backfilled with zeros)}

\item{b0}{(continuous, binary outcomes) model intercept}

\item{mainterms}{beta coefficients for X in the outcome model at referent (0) level of interacting variable}

\item{prodterms}{product term coefficients for interacting variable}

\item{ztype}{type of interacting variable: "continuous", "binary", "categorical"}

\item{q}{Number of levels or "quanta" of each exposure}

\item{yscale}{(continuous outcomes) error scale (residual error) for normally distributed outcomes}

\item{shape0}{(survival outcomes) baseline shape of weibull distribution \link[stats]{rweibull}}

\item{scale0}{(survival outcomes) baseline scale of weibull distribution \link[stats]{rweibull}}

\item{censtime}{(survival outcomes) administrative censoring time}

\item{ncheck}{(logical, default=TRUE) adjust sample size if needed so that exposures are exactly evenly distributed (so that qgcomp::quantize(exposure) = exposure)}

\item{...}{unused}
}
\value{
a data frame
}
\description{
Simulate quantized exposures for testing methods
}
\details{
Simulate continuous (normally distributed errors), binary (logistic function), or event-time outcomes as a linear function
}
\examples{
set.seed(50)
qdat = simdata_quantized_emm(
  outcomtype="continuous",
  n=10000, corr=c(.9, .3, 0, 0), mainterms=c(1, 1, 0, 0), prodterms=c(1, 1, 0, 0),
  q = 8
)
cor(qdat)
qdat = simdata_quantized_emm(
  outcomtype="continuous",
  n=10000, corr=c(-.9, .3, 0, 0), mainterms=c(1, 2, 0, 0), prodterms=c(1, 1, 0, 0),
  q = 4
)
cor(qdat)
table(qdat$x1)
qgcomp.emm.glm.noboot(y~x1+x2+x3+x4, expnms = c("x1", "x2", "x3", "x4"), emmvar = "z", data=qdat)
}
\seealso{
\code{\link[qgcomp]{qgcomp.boot}}, and \code{\link[qgcomp]{qgcomp.noboot}}
}
