% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item.r
\name{qiita_item}
\alias{qiita_item}
\alias{qiita_get_items}
\alias{qiita_post_item}
\alias{qiita_delete_item}
\alias{qiita_update_item}
\alias{qiita_stock_item}
\alias{qiita_unstock_item}
\alias{qiita_is_stocked_item}
\alias{qiita_get_stocks}
\title{Qiita Item (Article) API}
\usage{
qiita_get_items(
  item_id = NULL,
  tag_id = NULL,
  user_id = NULL,
  query = NULL,
  per_page = 100L,
  page_offset = 0L,
  page_limit = 1L
)

qiita_post_item(
  title,
  body,
  tags = qiita_util_tag("R"),
  coediting = FALSE,
  private = TRUE,
  gist = FALSE,
  tweet = FALSE
)

qiita_delete_item(item_id)

qiita_update_item(
  item_id,
  title,
  body,
  tags = list(qiita_util_tag("R")),
  private = TRUE
)

qiita_stock_item(item_id)

qiita_unstock_item(item_id)

qiita_is_stocked_item(item_id)

qiita_get_stocks(user_id, per_page = 100L, page_offset = 0L, page_limit = 1L)
}
\arguments{
\item{item_id}{Item (Article) ID.}

\item{tag_id}{Tag IDs (e.g. \code{"R"}).}

\item{user_id}{User ID (e.g. \code{"yutannihilation"}).}

\item{query}{Query string (e.g. \code{"dplyr user:yutannihlation"}).}

\item{per_page}{Number of items per one page.}

\item{page_offset}{Number of offset pages.}

\item{page_limit}{Max number of pages to retrieve.}

\item{title}{Title.}

\item{body}{Content body.}

\item{tags}{Tags. Use \code{qiita_util_tag} to generate tag objects.}

\item{coediting}{If \code{TRUE}, the post will be editable by team members.}

\item{private}{If \code{TRUE}, the post will be private.}

\item{gist}{If \code{TRUE}, post the code to Gist.}

\item{tweet}{If \code{TRUE}, notify on Twitter.}
}
\description{
Get, post, delete, stock or unstock articles via Qiita API.
}
\examples{
\dontrun{
# get items by item ID
qiita_get_items(item_id = "7a78d897810446dd6a3b")

# get items by tag ID
qiita_get_items(tag_id = c("dplyr", "tidyr"), per_pages = 10L, page_limit = 1L)

# get items by user ID
qiita_get_items(user_id = "yutannihilation")

# Post an item. Note that the post is private by default.
# You should manually check if the post is valid before make it public.
item <- qiita_post_item(title = "test", body = "This is an example.")

# update the post
qiita_update_item(item$id, title = "test", body = "**This is a strong example!**")

# delete the post
qiita_delete_item(item$id)
}

}
