% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_growth.R
\name{market_growth}
\alias{market_growth}
\title{Collects growth z-scores for companies}
\usage{
market_growth(
  companies = qmj::companies_r3k16,
  financials = qmj::financials_r3k16
)
}
\arguments{
\item{companies}{A data frame of company names and tickers.}

\item{financials}{A data frame containing financial
statements for every company.}
}
\value{
data.frame of market growth values
}
\description{
Given a data frame of companies (names and tickers) and 
a data frame of financial statements, calculates GPOA, 
ROE, ROA, CFOA, GMAR, ACC over a four-year time span
and determines the z-score of overall growth for each 
company based on the paper Quality Minus Junk 
(Asness et al.) in Appendix page A2.
}
\examples{
market_growth(companies_r3k16[1,], financials_r3k16)
}
\seealso{
\code{\link{market_data}}

\code{\link{market_profitability}}

\code{\link{market_safety}}

\code{\link{market_payouts}}
}
