% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makegvflow.r
\name{makegvflow}
\alias{makegvflow}
\title{Create a Quarto Graphviz Flow Diagram from Plain Text With Variable Insertions}
\usage{
makegvflow(
  .object.,
  ...,
  direction = c("TD", "LR"),
  style = "filled",
  shape = "box",
  font = "Times-Roman",
  fontsize = 18,
  fontcolor = "blue",
  fillcolor = "azure",
  penwidth = 0.1,
  arrowcolor = "blue3",
  arrowsize = 0.7,
  width = 30,
  lbdouble = TRUE,
  extracon = NULL,
  file,
  onlyprint = FALSE
)
}
\arguments{
\item{.object.}{character string or vector of plain text plus possible $\LaTeX$ math delimited by single dollar signs.  An empty initial line is ignore, so the user need not worry about having an initial quote mark on a line by itself.}

\item{...}{name=value pairs that makes values replace \code{{{name}}} elements in the markup}

\item{direction}{direction of the flow chart, default is top-down}

\item{style}{node style}

\item{shape}{node shape}

\item{font}{font for text in nodes}

\item{fontsize}{text font size}

\item{fontcolor}{text color}

\item{fillcolor}{node fill color}

\item{penwidth}{thickness of lines for node borders}

\item{arrowcolor}{arrow color}

\item{arrowsize}{arrow size}

\item{width}{text width for word-wrapping}

\item{lbdouble}{set to \code{FALSE} to use a single line break for "+" lines}

\item{extracon}{one or more text strings specifying extra connections between nodes using node names \code{nijk} for major level \code{i}, minor level \code{j}, tiny level \code{k} (as many of these that are applicable).  For example specify \code{extracon=c('n1 -> n2', 'n21 -> n31')}.}

\item{file}{name of file to hold \code{graphviz} markup after variable insertions.  Run this in Quarto using a chunk to looks like what is below, which was for \code{file='graphviz.dot'}.}

\item{onlyprint}{set to \code{TRUE} to only print the generated \code{graphiz} markup and not save it to \code{file}

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{dot\}
//| label: fig-flow1
//| fig-height: 4
//| fig-cap: "Chart caption"
//| file: graphviz.dot
```
}\if{html}{\out{</div>}}}
}
\value{
nothing; used to \code{knitr::knit_expand()} graphviz markup
}
\description{
Takes a character string or vector and creates a \code{graphviz} flowchart from the
hierarchy indicated by the number of indended spaces in each line.  The text
for the root levels is not indented, and major, minor, and tiny levels are indented
2, 4, or 6 spaces, respectively.  Default color, font size, and fill color are
chosen so that the chart is suitable for presentations.  Simple $\LaTeX$ math
markup is converted to simple HTML markup using \code{\link[tth:tth]{tth::tth()}}.  Text lines
are automatically wrapped to keep text boxes from being too wide.  Text lines
beginning with "+" are combined with the previous major, minor, or tiny text line
but separated by a double line break (single break if \code{lbdouble=FALSE}).
}
\details{
The function uses \code{\link[knitr:knit_expand]{knitr::knit_expand()}} to apply variable insertions before the diagram is rendered by Quarto.  See \href{https://hbiostat.org/rflow/doverview.html#sec-doverview-filter/}{this} for an example.  ##' @title makegvflow
}
\examples{
x <- '
Root text
  Major 1
    Minor 11 {{jj}}
    Minor 12
  Major 2
    Minor 21
    Minor 22
    Minor 23 that is very very long and just keeps going
      tiny 231 and $\\\\alph + \\\\sum_{i=1}^{n}X_{i}$
      tiny 232
      + a second line for tiny 232 that is pretty long
      + a third line for tiny 232
  Major 3
    Minor 31
      tiny 311'
makegvflow(x, extracon='n12 -> n21', jj='tiger', onlyprint=TRUE)
}
\seealso{
\code{\link[=makegraphviz]{makegraphviz()}}
}
\author{
Frank Harrell
}
