% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{zstd_decompress_raw}
\alias{zstd_decompress_raw}
\title{Zstd decompression}
\usage{
zstd_decompress_raw(data)
}
\arguments{
\item{data}{A raw vector to be decompressed.}
}
\value{
The decompressed data as a raw vector.
}
\description{
Decompresses a zstd compressed raw vector.
}
\examples{
x <- 1:1e6
xserialized <- serialize(x, connection=NULL)
xcompressed <- zstd_compress_raw(xserialized, compress_level = 1)
xrecovered <- unserialize(zstd_decompress_raw(xcompressed))
}
