% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_samplers_univariate.R
\name{slice_genelliptical}
\alias{slice_genelliptical}
\title{Generalized Elliptical Slice Sampler (univariate)}
\usage{
slice_genelliptical(x, log_target, mu, sigma, df)
}
\arguments{
\item{x}{The current state (as a numeric scalar).}

\item{log_target}{A function taking numeric scalar that evaluates the
(potentially unnormalized) log-target density, returning a numeric scalar.}

\item{mu}{A numeric scalar with the mean of the supporting normal distribution.}

\item{sigma}{A numeric scalar with the standard deviation of the supporting normal distribution.}

\item{df}{Degrees of freedom of Student t pseudo-target.}
}
\value{
A list contains two elements:

\code{x} is the new state.

\code{nEvaluations} is the number of evaluations of the target function used to obtain the new
state.
}
\description{
Single update using the generalized elliptical slice sampler of Nishihara et al. (2014).
}
\examples{
lf <- function(x) dbeta(x, 3, 4, log = TRUE)
draws <- numeric(10) # set to numeric(1e3) for more complete illustration
nEvaluations <- 0L
for (i in seq.int(2, length(draws))) {
  out <- slice_genelliptical(draws[i - 1], log_target = lf,
                                      mu = 0.5, sigma = 1, df = 5)
  draws[i] <- out$x
  nEvaluations <- nEvaluations + out$nEvaluations
}
nEvaluations / (length(draws) - 1)
plot(density(draws), xlim = c(0, 1))
curve(exp(lf(x)), 0, 1, col = "blue", add = TRUE)

}
\references{
Nishihara, R., Murray, I., and Adams, R. P. (2014), "Parallel MCMC with Generalized Elliptical Slice Sampling," \emph{Journal of Machine Learning Research}, 15, 2087-2112. \url{https://jmlr.org/papers/v15/nishihara14a.html}
}
