% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_samplers_univariate.R
\name{slice_quantile}
\alias{slice_quantile}
\title{Quantile Slice Sampler}
\usage{
slice_quantile(x, log_target, pseudo)
}
\arguments{
\item{x}{The current state (as a numeric scalar).}

\item{log_target}{A function taking numeric scalar that evaluates the
(potentially unnormalized) log-target density, returning a numeric scalar.}

\item{pseudo}{List containing two functions specifying the pseudo-target distribution:

\code{ld} evaluates the log density for a scalar input, and

\code{q} evaluates the quantile (inverse-CDF) function for an input in (0,1).}
}
\value{
A list containing three elements:

\code{x} is the new state.

\code{u} is the value of the CDF of the psuedo-target associated with the
returned value (also referred to as psi).

\code{nEvaluations} is the number of evaluations of the
target function used to obtain the new state.
}
\description{
Single update using a quantile slice sampler of Heiner et al. (2024+).
}
\examples{
lf <- function(x) dbeta(x, 3, 4, log = TRUE)
pseu <- list(ld = function(x) dbeta(x, shape1 = 1, shape2 = 1, log = TRUE),
             q = function(u) qbeta(u, shape1 = 1, shape2 = 1))
draws <- numeric(10) # set to numeric(1e3) for more complete illustration
nEvaluations <- 0L
for (i in seq.int(2, length(draws))) {
  out <- slice_quantile(draws[i - 1], log_target = lf, pseudo = pseu)
  draws[i] <- out$x
  nEvaluations <- nEvaluations + out$nEvaluations
}
nEvaluations / (length(draws) - 1)
plot(density(draws), xlim = c(0, 1))
curve(exp(lf(x)), 0, 1, col = "blue", add = TRUE)

}
\references{
Heiner, M. J., Johnson, S. B., Christensen, J. R., and Dahl, D. B. (2024+), "Quantile Slice Sampling," \emph{arXiv preprint arXiv:###}.
}
