% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{read_qst}
\alias{read_qst}
\title{Read a data.frame from an SQLite database}
\usage{
read_qst(path, lazy = FALSE)
}
\arguments{
\item{path}{The path to read from.}

\item{lazy}{If TRUE, the full data.frame will not be read into
memory, but instead a lazy evaluated data.frame will
be returned.}
}
\value{
A data.frame read from the SQLite file found at path
}
\description{
This function reads a data.frame from an SQLite database.
The database has one table, named data, containing the data.
Additional tables, prefixed with meta_, may be added in the
future to support additional data types not supported
in a native way by SQLite.

By specifying lazy=TRUE, the data.frame will not be read into
memory on the read operation, but instead a lazy
evaluated data.frame will be returned. This results in a
near-instantaneous read operation, but subsequent operation
will then be done from disk using SQL translation when the
data.frame is passed to other functions or collect() is
called on it.
}
\examples{
# Write the cars data set to a file, then read it back
cars_db <- tempfile()
write_qst(cars, cars_db, indexes=list("speed"))
dat <- read_qst(cars_db)
unlink(cars_db)

}
