% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele1.R, R/ggplot_allele1.R
\name{allele1}
\alias{allele1}
\alias{ggplot_allele1}
\alias{autoplot.allele1}
\title{Allele plot for SNPs, alleles and allele pairs}
\usage{
allele1(
  probD,
  phe_df = NULL,
  cov_mx = NULL,
  map = NULL,
  K_chr = NULL,
  patterns = NULL,
  alt = NULL,
  blups = FALSE,
  ...
)

ggplot_allele1(
  object,
  scan1_object = NULL,
  map = NULL,
  pos = NULL,
  trim = TRUE,
  legend.position = "none",
  ...
)

\method{autoplot}{allele1}(object, ...)
}
\arguments{
\item{probD}{object of class \code{\link[qtl2]{calc_genoprob}}}

\item{phe_df}{data frame with one phenotype}

\item{cov_mx}{covariate matrix}

\item{map}{Genome map (required if \code{scan1_object} present).}

\item{K_chr}{kinship matrix}

\item{patterns}{data frame of pattern information}

\item{alt}{Haplotype allele letter(s) for alternative to reference.}

\item{blups}{Create BLUPs if \code{TRUE}}

\item{...}{Other parameters ignored.}

\item{object}{Object of class \code{\link{allele1}}.}

\item{scan1_object}{Optional object of class \code{\link[qtl2]{scan1}} to find peak.}

\item{pos}{Genome position in Mbp (supercedes \code{scan1_object}).}

\item{trim}{If \code{TRUE}, trim extreme alleles.}

\item{legend.position}{Legend position (default is \code{"none"}).}
}
\value{
Table with allele effects across sources.

object of class \code{\link[ggplot2]{ggplot}}
}
\description{
Create table of alleles for various model fits.

Plot alleles for haplotype, diplotype and top patterns and genome position.
}
