% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch3a.R
\docType{data}
\name{ch3a}
\alias{ch3a}
\title{Data with a phenotype error}
\format{
An object of class \code{cross}.  See \code{\link[qtl:read.cross]{qtl::read.cross()}}
for details.
}
\source{
Karl W Broman, \email{broman@wisc.edu}
}
\usage{
ch3a
}
\description{
Anonymous data with a phenotype error and a pair of individuals with very
similar phenotypes.
}
\details{
A backcross with 234 individuals, each with five phenotypes and typed at 166
markers.
}
\examples{
data(ch3a)

# phenotype problem
pairs(ch3a$pheno)
ch3a$pheno[ch3a$pheno[,4]==0,] # individual 159

# individuals with similar genotypes
library(qtl)
cg <- comparegeno(ch3a)
hist(cg, breaks=200)
max(cg[cg < 1])
which(cg == max(cg[cg < 1]), arr.ind=TRUE)

}
\references{
Broman, K. W. and Sen, S. (2009) \emph{A Guide to QTL Mapping
with R/qtl.} Springer, New York.
}
\seealso{
\code{\link{ch3b}}, \code{\link{ch3c}}
}
\keyword{datasets}
