% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantKrig.R
\name{quantKrig}
\alias{quantKrig}
\title{Quantile Kriging}
\usage{
quantKrig(x, y, quantv, lower, upper, method = "loo",
  type = "Gaussian", rs = TRUE, nm = TRUE, known = NULL,
  optstart = NULL, control = list())
}
\arguments{
\item{x}{Inputs}

\item{y}{Univariate Response}

\item{quantv}{Vector of Quantile values to estimate (ex: c(0.025, 0.975))}

\item{lower}{Lower bound of hyperparameters, if isotropic set lengthscale then nugget, if anisotropic set k lengthscales and then nugget}

\item{upper}{Upper bound of hyperparameters, if isotropic set lengthscale then nugget, if anisotropic set k lengthscales and then nugget}

\item{method}{Either maximum likelihood ('mle') or leave-one-out cross validation ('loo') optimization of hyperparameters}

\item{type}{Covariance type, either 'Gaussian', 'Matern3_2', or 'Matern5_2'}

\item{rs}{If TRUE, rescales inputs to [0,1]}

\item{nm}{If TRUE, normalizes output to mean 0, variance 1}

\item{known}{Fixes all hyperparamters to a known value}

\item{optstart}{Sets the starting value for the optimization}

\item{control}{Control from optim function}
}
\value{
\describe{
\item{quants}{The estimated quantile values in matrix form}
\item{yquants}{The actual quantile values from the data in matrix form}
\item{g}{The scaling parameter for the kernel}
\item{l}{The lengthscale parameter(s)}
\item{ll}{The log likelihood}
\item{beta0}{Estimated linear trend}
\item{nu}{Estimator of the variance}
\item{xstar}{Matrix of unique input values}
\item{ystar}{Average value at each unique input value}
\item{Ki }{Inverted covariance matrix}
\item{quantv}{Vector of alpha values between 0 and 1 for estimated quantiles, it is recommended that only a small number of quantiles are used for fitting and more quantiles can be found later using newQuants}
\item{mult}{Number of replicates at each input}
}
}
\description{
Implements Quantile Kriging from Plumlee and Tuo (2014).
}
\details{
Fits quantile kriging using a double exponential or Matern covariance function. This emulator is for a stochastic simulation and models the distribution of the results (through the quantiles), not just the mean.  The hyperparameters can be trained using maximum likelihood estimation or leave-one-out cross validation as recommended in Plumlee and Tuo (2014).  The GP is trained using the Woodbury formula to improve computation speed with replication as shown in Binois et al. (2018).  To get meaningful results, there should be sufficient replication at each input. The quantiles at a location \eqn{x0} are found using: \deqn{\mu(x0) + kn(x0)Kn^{-1}(y(i) - \mu(x)}) where \eqn{Kn} is the kernel of the design matrix (with nugget effect), \eqn{y(i)} the ordered sample closest to that quantile at each input, and \eqn{\mu(x)} the mean at each input.
}
\examples{
# Simple example
X <- seq(0,1,length.out = 20)
Y <- cos(5*X) + cos(X)
Xstar <- rep(X,each = 100)
Ystar <- rep(Y,each = 100)
Ystar <- rnorm(length(Ystar),Ystar,1)
lb <- c(0.0001,0.0001)
ub <- c(10,10)
Qout <- quantKrig(Xstar,Ystar, quantv = seq(0.05,0.95, length.out = 7), lower = lb, upper = ub)
QuantPlot(Qout, Xstar, Ystar)

#fit for non-normal errors

Ystar <- rep(Y,each = 100)
e <- rchisq(length(Ystar),5)/5 - 1
Ystar <- Ystar + e
Qout <- quantKrig(Xstar,Ystar, quantv = seq(0.05,0.95, length.out = 7), lower = lb, upper = ub)
QuantPlot(Qout, Xstar, Ystar)
}
\references{
\itemize{
\item Matthew Plumlee & Rui Tuo (2014) Building Accurate Emulators for Stochastic Simulations via Quantile Kriging, Technometrics, 56:4, 466-473, DOI: 10.1080/00401706.2013.860919
\item Mickael Binois, Robert B. Gramacy & Mike Ludkovski (2018) Practical Heteroscedastic Gaussian Process Modeling for Large Simulation Experiments, Journal of Computational and Graphical Statistics, 27:4, 808-821, DOI: 10.1080/10618600.2018.1458625
}
}
