% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagKernelWeight.R
\name{LagKernelWeight-constructor}
\alias{LagKernelWeight-constructor}
\alias{lagKernelWeight}
\title{Create an instance of the \code{\link{LagKernelWeight}} class.}
\usage{
lagKernelWeight(
  W = WParzen,
  bw = K/2,
  K = 10,
  descr = paste("bw=", bw, ", K=", K, sep = "")
)
}
\arguments{
\item{W}{A kernel function}

\item{bw}{bandwidth}

\item{K}{a \code{numeric} that determines the largest lag. The weight will be
computed for the \eqn{K} integers \eqn{0:(K-1)}; by default the number
\code{K} specified on construction.}

\item{descr}{a description to be used in some plots}
}
\value{
Returns an instance of \code{LagKernelWeight}.
}
\description{
Create an instance of the \code{\link{LagKernelWeight}} class.
}
\examples{
wgt1 <- lagKernelWeight(W=WParzen, K=20, bw=10)
print(wgt1)
}
\seealso{
\code{\link{kernels}}
}
\keyword{Constructors}
