% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.computeCoherency}
\alias{.computeCoherency}
\title{Workhorse function for \code{\link{getCoherency-SmoothedPG}}.}
\arguments{
\item{V}{a 3-dimensional array of complex numbers; dimensions are
\code{[N, K1, K2]}, where \code{N} frequencies are
\eqn{\omega_j := 2\pi j/N} for \eqn{j=0,\ldots,N}.}

\item{W}{a vector of length \code{W} of length \code{N} used for smoothing.}
}
\value{
Returns an array with complex numbers
        \eqn{\sigma(\tau_1, \tau_2, \omega_j} as defined in
        Kley et. al (2016), p. 26.
}
\description{
C++ implementation to increase performance.
}
\references{
Barunik, J. & Kley, T. (2019).
Quantile Coherency: A General Measure for Dependence Between Cyclical
Economic Variables. Econometrics Journal, 22, 131--152.
\url{http://arxiv.org/abs/1401.8104}.
}
\keyword{internals}
