% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blog.R
\name{new_blog_post}
\alias{new_blog_post}
\title{Create a new blog post}
\usage{
new_blog_post(
  title,
  dest = NULL,
  wd = NULL,
  open = rlang::is_interactive(),
  call = rlang::current_env(),
  ...
)
}
\arguments{
\item{title}{A character string for the title of the post. It is converted
to title case via \code{\link[tools:toTitleCase]{tools::toTitleCase()}}.}

\item{dest}{A character string (or NULL) for the path within \code{posts}. By
default, the title is adapted as the directory name.}

\item{wd}{An optional working directory. If \code{NULL}, the current working is used.}

\item{open}{A logical: have the default editor open a window to edit the
\code{index.qmd} file?}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{...}{A named list of values to be added to the yaml header, such as
\code{date}, \code{author}, \code{categories}, \code{description}, etc.
If no \code{date} is provided, the current date is used.
If no \code{author} is provided, \code{whoami::fullname()} is used to get the user's name.}
}
\value{
The path to the index file.
}
\description{
Creates (and potentially opens) the \code{index.qmd} file for a new blog post.
}
\examples{
\dontrun{\donttest{
new_blog_post("making quarto blog posts", categories = c("R"))
}}

}
