% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R, R/config.R
\docType{data}
\name{query-condition}
\alias{query-condition}
\alias{queryCondition}
\alias{setQueryConditions}
\alias{listQueryConditions}
\alias{default_conditions}
\title{Register new or list existing query conditions}
\format{
An object of class \code{list} of length 2.
}
\usage{
queryCondition(method)

setQueryConditions(..., .queryBuilderConfig = queryBuilderConfig)

listQueryConditions(.queryBuilderConfig = queryBuilderConfig, print = TRUE)

default_conditions
}
\arguments{
\item{method}{R function of two parameters that is used to combine a pair of rules.}

\item{...}{Name-value pairs defining condition name and method respectively.
Should be defined with usage of \code{queryCondition} function.}

\item{.queryBuilderConfig}{R6 class object storing query configuration. See \link{queryBuilderConfigClass}.}

\item{print}{Should the list of operators be printed into console?}
}
\description{
Condition is two-argument function such as `|` or `&` used to combine pair of rules.
}
\details{
\itemize{
  \item{\code{queryCondition}: defines condition method.}
  \item{\code{setQueryConditions}:
    is used to register the defined conditions in the default or custom \link{queryBuilderConfigClass} object.
  }
  \item{\code{listQueryConditions}: returns list of registered conditions.}
  \item{\code{default_conditions}: an object storing default definitions for conditions.}
}
}
\examples{
setQueryConditions(
  "XOR" = queryCondition(xor)
)
query <- queryGroup(
  condition = "XOR",
  queryRule("am", "equal", 1),
  queryRule("vs", "equal", 1)
)
queryToExpr(query)

}
\keyword{datasets}
