% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_queuefunctions.R
\name{queue_step}
\alias{queue_step}
\title{Compute the departure times and queue lengths for a queueing system from arrival and service times.}
\usage{
queue_step(arrivals, service, servers = 1, labels = NULL)
}
\arguments{
\item{arrivals}{numeric vector of non-negative arrival times}

\item{service}{numeric vector of service times with the same ordering as arrival_df.}

\item{servers}{a non-zero natural number, an object of class \code{server.stepfun}
or an object of class \code{server.list}.}

\item{labels}{character vector of customer labels (deprecated).}
}
\value{
An list object of class \code{queue_list} with the following components: \cr
\cr
\itemize{
  \item \code{departures} - A vector of response times for the input of arrival times and service times.
  \item \code{server} - A vector of server assignments for the input of arrival times and service times.
  \item \code{departures_df} - A data frame with arrivals, service, departures, waiting, system time, and server assignments for each customer.
  \item \code{queuelength_df} - A data frame describing the evolution of queue length over time
  \item \code{systemlength_df} - A data frame describing the evolution of system length over time
  \item \code{servers_input} - A copy of the server argument
  \item \code{state} - A vector of availability times for the servers
}
}
\description{
Compute the departure times and queue lengths for a queueing system from arrival and service times.
}
\details{
If only departure times are needed, the \code{\link{queue}} function is faster.
}
\examples{

# With two servers
set.seed(1)
n <- 100

arrivals <- cumsum(rexp(n, 3))
service <- rexp(n)


queue_obj <- queue_step(arrivals,
    service = service, servers = 2)


summary(queue_obj)
plot(queue_obj, which = 5)

# It seems like the customers have a long wait.
# Let's put two more servers on after time 20


server_list <- as.server.stepfun(c(20),c(2,4))

queue_obj2 <- queue_step(arrivals,
    service = service,
    servers = server_list)

summary(queue_obj2)
if(require(ggplot2, quietly = TRUE)){

    plot(queue_obj2, which = 5)

}


}
\seealso{
\code{\link{queue}}, \code{\link{summary.queue_list}}, \code{\link{plot.queue_list}}
}
