% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort_length}
\alias{sort_length}
\alias{sort_file_type}
\title{Sort vector by length or file types of its content}
\usage{
sort_length(vec, asc = TRUE)

sort_file_type(files, asc = TRUE)
}
\arguments{
\item{vec}{a vector}

\item{asc}{A logical value indicating whether to sort in ascending (TRUE) or descending (FALSE) order. Default is TRUE.}

\item{files}{A character vector containing file names to be sorted}
}
\value{
vector of items sorted by length

A character vector of sorted file names
}
\description{
Sort the length or file types of the content of a vector

Takes a vector of file names and sorts them by their file extensions (file type)
}
\note{
This function removes all NAs prior to sorting the vector
}
\examples{
# sort by length of content
x = c("acs","tt","jdssr","h","grab")
sort_length(vec = x) # ascending order of length
sort_length(vec = x, asc = FALSE) # descending order of length


files <- c("doc1.pdf",
  "image.jpg", "house.csv", "notes.txt",
  "patab","doc2.pdf", "data.csv", "pic.png","cotab")
sort_file_type(files)
sort_file_type(files, asc = FALSE)

}
