% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quilt_form_data.R
\name{quilt_form_data}
\alias{quilt_form_data}
\title{Format text data to structure needed for \code{quilt_write_form()}}
\usage{
quilt_form_data(
  prompt = NULL,
  text,
  response_type,
  options,
  addID = TRUE,
  nlow,
  nhigh,
  remove_NA = FALSE
)
}
\arguments{
\item{prompt}{character string: prompt of text for labelling, e.g.: "Label this text: "; defaults to \code{NULL}}

\item{text}{character vector: text inputs for labelling}

\item{response_type}{character vector: one of c("yesno", "options", "scale", "text")}

\item{options}{character vector of response options: e.g., c("big", "small", "biggie smalls")}

\item{addID}{add an ID variable to the text data}

\item{nlow}{integer: low end of numeric scale}

\item{nhigh}{integer: high end of numeric scale}

\item{remove_NA}{if \code{TRUE}: removes empty rows of text}
}
\value{
a data.frame
}
\description{
Format text data to structure needed for \code{quilt_write_form()}
}
\examples{
\dontrun{

data(lipsum_text)

qdat <- quilt_form_data(prompt = "Label this text: ",
                        text = lipsum_text$text, response_type = "yesno",
                        addID = T)

qdat <- quilt_form_data(prompt = "Label this text: ",
                        text = lipsum_text$text, response_type = "options",
                        options = c("Not at all", "Somewhat", "Very much"),
                        addID = T)

qdat <- quilt_form_data(prompt = "Label this text: ",
                        text = lipsum_text$text, response_type = "scale",
                        nlow = 1, nhigh = 10, addID = T)
}
}
