% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_e91_simulation.R
\name{run_e91_simulation}
\alias{run_e91_simulation}
\title{E91 Quantum Key Distribution (QKD) Simulation}
\usage{
run_e91_simulation(
  eavesdropping_active = FALSE,
  key_length = 1000,
  noise_level = 0.5
)
}
\arguments{
\item{eavesdropping_active}{Logical. If \code{TRUE}, the entanglement is partially
destroyed, simulating an attack that forces the system toward the classical limit
where \eqn{|S| \leq 2}. Default is \code{FALSE}.}

\item{key_length}{Integer. Number of simulated EPR pairs (default = 1000).}

\item{noise_level}{Numeric. Noise level (0-1) applied when
\code{eavesdropping_active = TRUE}, reducing quantum correlation.
A value of 0.5 represents partial decoherence. Default is 0.5.}
}
\value{
A list of class \code{"E91Simulation"} containing:
\describe{
\item{\code{S_Calculated}}{Observed Bell CHSH statistic.}
\item{\code{S_Theoretical}}{Quantum theoretical value (\eqn{\approx} -2.8284).}
\item{\code{Bell_Violation}}{\code{TRUE} if \eqn{|S| > 2} (secure),
\code{FALSE} if \eqn{|S| \leq 2} (insecure).}
\item{\code{Sifted_Key_Length}}{Number of bits retained for key formation.}
\item{\code{Eavesdropping}}{Indicates if an attack was simulated.}
}
}
\description{
Simulates the E91 (Ekert 1991) quantum key distribution protocol using entangled
particle pairs (EPR) and Bell’s theorem (CHSH statistic) to ensure channel security.
Security is established when the \strong{Bell Inequality is violated}, i.e.
when \eqn{|S| > 2}, indicating quantum behavior.
}
\details{
El E91 se diferencia de BB84 en que la detección del espía es \strong{simultánea} a la generación
de la clave. Los pares de bases son separados en dos conjuntos:
\enumerate{
\item \strong{Clave Secreta:} Pares con perfecta anti-correlación (ej. a2-b1, a3-b2).
\item \strong{Test de Bell:} Pares restantes usados para calcular la esperanza $E(a_i, b_j)$ y el valor $S$.
}
Si $S$ cae por debajo de 2 (límite clásico de Bell), se concluye que el entrelazamiento ha sido
roto por Eve, y la clave debe descartarse.
}
\examples{
# Escenario 1: Canal Cuántico Seguro (No Eavesdropping)
results_secure <- run_e91_simulation(eavesdropping_active = FALSE)
cat("--- Escenario 1: Sin Eavesdropping ---\n")
cat(paste("S Calculado:", round(results_secure$S_Calculated, 4), "\n"))
cat(paste("Violación de Bell:", results_secure$Bell_Violation, "\n"))

# Escenario 2: Ataque que Rompe el Entrelazamiento
results_attack <- run_e91_simulation(eavesdropping_active = TRUE)
cat("\n--- Escenario 2: Con Ataque ---\n")
cat(paste("S Calculado:", round(results_attack$S_Calculated, 4), "\n"))
cat(paste("Violación de Bell:", results_attack$Bell_Violation, "\n"))

}
\references{
Ekert, A. K. (1991). \emph{Quantum cryptography based on Bell's theorem.}
Physical Review Letters, 67(6), 661.
}
