% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{fireworkMessenger}
\alias{fireworkMessenger}
\alias{showFireworks}
\alias{removeFireworks}
\alias{addRmdFireworks}
\title{Widget to initiate or terminate fireworks display}
\usage{
fireworkMessenger(
  type,
  duration = NULL,
  speed = NULL,
  particleCount = 30,
  session = getDefaultReactiveDomain()
)

showFireworks(
  speed = 1,
  particleCount = 40,
  session = getDefaultReactiveDomain()
)

removeFireworks(session = getDefaultReactiveDomain())

addRmdFireworks(speed = 1, particleCount = 40)
}
\arguments{
\item{type}{type of action e.g start, remove}

\item{duration}{duration of fireworks outbursts}

\item{speed}{speed of display of fireworks}

\item{particleCount}{particle size of fireworks}

\item{session}{session object from server}
}
\value{
inclusion or exclusion of fireworks from page

visible firework canvas on the page

removal of firework canvas from the page

addition of firework canvas on the page
}
\description{
Add or remove fireworks graphics from page

Add fireworks visuals to page

Remove fireworks visuals from page

Add fireworks visuals to Rmarkdown page
}
\examples{
# In R markdown documents
library(r2fireworks)
useFireworks()
addRmdFireworks(particleCount = 100, speed = 3)

}
