% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/rd.R
\name{m_add_model}
\alias{m_add_model}
\alias{m_add_models}
\alias{add_model}
\title{Create and add model to viewer}
\usage{
m_add_model(
  id,
  data,
  format = c("pdb", "sdf", "xyz", "pqr", "mol2", "cif"),
  keepH = FALSE,
  options = list()
)

m_add_models(id, data, format = c("pdb", "sdf", "xyz", "pqr", "mol2", "cif"))
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{data}{Path of input data path or a vector of data.}

\item{format}{Input format (\code{'pdb'}, \code{'sdf'}, \code{'xyz'},
\code{'pqr'}, or \code{'mol2'}).}

\item{keepH}{Default to FALSE, whether to keep or strip hydrogens from
imported model.}

\item{options}{Format dependent options. Attributes depend on the input file
format.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Create and add model to viewer, given molecular data and its format. If
multi-model file is provided, use \code{\link{m_add_models}} adding atom data
to the viewer as separate models.
}
\examples{
library(r3dmol)

# Single-model file with m_add_model() function
r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb")

# Multi-model file with m_add_models() function
r3dmol() \%>\%
  m_add_models(data = sdf_multiple, "sdf") \%>\%
  m_zoom_to()

# Multi-model file with m_add_model() function
r3dmol() \%>\%
  m_add_model(data = sdf_multiple, "sdf") \%>\%
  m_zoom_to()

# Add model and keep hydrogens.
\dontrun{
r3dmol() \%>\%
  m_add_model(m_fetch_pdb("5D8V"), keepH = TRUE) \%>\%
  m_set_style(m_style_sphere()) \%>\%
  m_zoom_to() \%>\%
  m_spin()
}
}
