% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sel.R
\name{m_multi_resi_sel}
\alias{m_multi_resi_sel}
\title{Selection Across Multiple Residues}
\usage{
m_multi_resi_sel(
  resi = NULL,
  resn = NULL,
  chain = NULL,
  model = NULL,
  elem = NULL,
  atom = NULL,
  invert = NULL,
  byres = NULL,
  b = NULL,
  expand = NULL,
  bonds = NULL,
  ss = NULL,
  clickable = NULL,
  callback = NULL
)
}
\arguments{
\item{resi}{Residue number/s. (vector)}

\item{resn}{Parent residue name as 3-letter code (e.g. "ALA", "GLY",
"CYS"...)}

\item{chain}{String, chain this atom belongs to (e.g. 'A' for chain A)}

\item{model}{a single model or list of models from which atoms should be
selected. Can also specify by numerical creation order.
Reverse indexing is allowed (-1 specifies last added model).}

\item{elem}{element abbreviation (e.g 'H', 'Ca', etc)}

\item{atom}{Atom name, may be more specific than 'elem' (e.g. 'CA' for alpha
carbon)}

\item{invert}{Logical, if \code{invert = TRUE}, Inverts the selection
criteria.}

\item{byres}{Logical, if \code{byres = TRUE}, expands the selection to
entire residues that include any selected atoms.}

\item{b}{Atom b factor data}

\item{expand}{Expand selection to include atoms within a specified distance
from current selection.
all atoms of any residue that has any atom already selected.}

\item{bonds}{overloaded to select number of bonds, e.g. \code{bonds = 0}
will select all non-bonded atoms}

\item{ss}{Secondary structure identifier. 'h' for helix, 's' for beta-sheet.}

\item{clickable}{Set this flag to true to enable click selection handling
for this atom}

\item{callback}{Callback click handler function to be executed on this atom
and its parent viewer.}
}
\value{
sel \code{list()} for selecting atoms.
}
\description{
Behaves just like the \code{m_sel()}, but returns a new selection for each
residue specified with \code{resi}.
}
\details{
The \code{m_sel(resi = 1:10)} returns a selection of all 10 residues.
The \code{m_multi_resi_sel(resi = 1:10)} returns 10 individual selections,
each containing only 1 of the residues.
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl) \%>\%
  m_set_style(style = m_style_cartoon()) \%>\%
  m_zoom_to() \%>\%
  m_add_style(
    sel = m_sel(resi = 1:10),
    style = c(
      m_style_stick(),
      m_style_sphere(scale = 0.3)
    )
  ) \%>\%
  m_add_line(
    start = m_multi_resi_sel(resi = rep(1, 9), chain = "A"),
    end = m_multi_resi_sel(
      resi = 2:10,
      chain = "B"
    )
  )
}
