% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r5r_gui.R
\name{r5r_gui}
\alias{r5r_gui}
\title{Run the r5rgui Shiny Application}
\usage{
r5r_gui(r5r_network, center = NULL, zoom = NULL, departure_date = Sys.Date())
}
\arguments{
\item{r5r_network}{A pre-built 'r5r' network object. This object contains the street and transit network data required for routing calculations.}

\item{center}{A numeric vector of length 2, specifying the initial longitude and latitude for the map's center. If \code{NULL} (the default), the map will be centered on the bounding box of the \code{r5r_network}. If \code{{r5r}} is below version 2.4.0, calculating the bounding box may be slow.}

\item{zoom}{An integer specifying the initial zoom level of the map. If \code{NULL} (the default), the zoom level will be automatically calculated to fit the bounding box of the \code{r5r_network}. If \code{{r5r}} is below version 2.4.0, calculating the bounding box may be slow.}

\item{departure_date}{A Date object specifying the initial departure date for the trip. Defaults to the current system date.}
}
\value{
This function does not return a value; it launches a Shiny application.
}
\description{
This function launches a Shiny application that provides a graphical
user interface for the 'r5r' package, allowing for interactive transit routing.
}
\examples{
if (interactive()) {
  # First, build the r5r network
  library(r5r)

  # Note: This requires a valid r5r network.
  # Using the sample data included in the r5r package:
  data_path <- system.file("extdata/poa", package = "r5r")
  r5r_network <- setup_r5(data_path = data_path)

  # Launch the application without specifying center and zoom
  # The map will be automatically centered and zoomed to the network's extent
  r5r_gui(r5r_network)

  # Launch with a specific departure date with auto-zoom and center
  r5r_gui(r5r_network, departure_date = as.Date("2019-05-13"))

  # Manually define map center and zoom
  map_center <- c(-51.22, -30.05)
  map_zoom <- 11
  r5r_gui(r5r_network, center = map_center, zoom = map_zoom)
}
}
