% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amPlot.R
\name{amLines}
\alias{amLines}
\title{amLines adds a serie to a graph.}
\usage{
amLines(
  chart,
  x = NULL,
  y = NULL,
  type = c("points", "line", "smoothedLine", "both", "step"),
  col = "#0066cc",
  title,
  fill_alphas = 0,
  balloon = T
)
}
\arguments{
\item{chart}{\linkS4class{AmChart}. Chart you wish to add the new serie.}

\item{x}{\code{numeric}, equivalent to y, deprecated.}

\item{y}{\code{numeric}.}

\item{type}{(optionnal) \code{character}. Possible values are : "l" for line, 
"p" for points, "b" for both, "sl" for smoothed line, "st" for step}

\item{col}{\code{character}, color of the new serie.}

\item{title}{\code{character}, name of the new serie, used when legend is enabled.}

\item{fill_alphas}{a \code{numeric} between 0 and 1 for printed area.}

\item{balloon}{\code{logical}, add balloon with value or not}
}
\description{
amLines adds a new serie to an existing serial chart.
}
\note{
It is supposed here that x or y corresponds to the y-axis, and the x-axis
is automatically linked to the x values of the chart "chart". That is why it makes
sense to give the y argument.
}
\examples{
if (requireNamespace("pipeR", quietly = TRUE)) {
require(pipeR)
amPlot(x = rnorm(100), type = 'sl') \%>>\%
  amLines(x = rnorm(100), type = "p")
}

\dontrun{
amPlot(x = rnorm(100), type = 'sl') \%>>\%
  amLines(x = rnorm(100), col = "blue") \%>>\%
  amLines(x = rnorm(100), type = "sl") \%>>\%
  amLines(x = rnorm(100), type = "p")

# For an XY chart
x <- sort(rnorm(100))
y1 <- rnorm(100, sd = 10)
y2 <- rnorm(100, sd = 10)
y3 <- rnorm(100, sd = 10)
amPlot(x = x, y = y1) \%>>\%
  amLines(x = y2, col = "blue") \%>>\%
  amLines(x = y3, type = "p")
}

}
