% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{dupGet}
\alias{dupGet}
\title{Detect deviants from SNPs; classify SNPs}
\usage{
dupGet(
  data,
  Fis,
  test = c("z.het", "z.05", "z.all", "chi.het", "chi.05", "chi.all"),
  intersection = FALSE,
  method = c("fisher", "chi.sq"),
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{data frame of the output of \code{allele.info}}

\item{Fis}{numeric. Inbreeding coefficient calculated using \code{h.zygosity()} function}

\item{test}{character. type of test to be used for significance. See details}

\item{intersection}{logical, whether to use the intersection of the methods
specified in \code{test} (if more than one)}

\item{method}{character. method for testing excess of heterozygotes.
Fisher exact test (\code{fisher}) or Chi-square test (\code{chi.sq})}

\item{plot}{logical. whether to plot the detected singlets and duplicates
on allele ratio vs. proportion of heterozygotes plot.}

\item{verbose}{logical. show progress}

\item{\dots}{additional parameters passed on to \code{plot}}
}
\value{
Returns a data frame of snps/alleles with their duplication status
}
\description{
Detect deviant SNPs using excess of heterozygotes
(alleles that do not follow HWE) and allelic-ratio deviations
(alleles with ratios that do not follow a normal Z-score or chi-square
distribution).
See details.
}
\details{
SNP deviants are detected with both excess of heterozygosity
according to HWE and deviant SNPs where depth values fall outside of the
normal distribution are detected using the
following methods:
\itemize{
\item{Z-score test \eqn{Z_{x} = \sum_{i=1}^{n} Z_{i}};
\eqn{Z_{i} = \frac{\left ( (N_{i}\times p)- N_{Ai} \right )}{\sqrt{N_{i}\times p(1-p)}}}}
\item{chi-square test \eqn{X_{x}^{2} = \sum_{i-1}^{n} X_{i}^{2}};
\eqn{X_{i}^{2} = (\frac{(N_{i}\times p - N_{Ai})^2}{N_{i}\times p} + \frac{(N_{i}\times (1 - p)- (N_{i} - N_{Ai}))^2}{N_{i}\times (1-p)})}}
}
See references for more details on the methods

Users can pick among Z-score for heterozygotes (\code{z.het, chi.het}),
all allele combinations (\code{z.all, chi.all}) and the assumption of no
probe bias p=0.5 (\code{z.05, chi.05})
}
\examples{
\dontrun{data(alleleINF)
DD<-dupGet(alleleINF,Fis=0.1,test=c("z.05","chi.05"))}

}
\author{
Piyal Karunarathne Qiujie Zhou
}
