% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{output_all}
\alias{output_all}
\title{Output IACI of all grids}
\usage{
output_all(
  si,
  input_dir,
  output_dir,
  freq = c("monthly", "seasonal"),
  base.range = c(1961, 1990),
  time.span = c(1961, 2022)
)
}
\arguments{
\item{si}{Data frame. Sea level input data.}

\item{input_dir}{Character. Directory containing input CSV files.}

\item{output_dir}{Character. Directory to save output files.}

\item{freq}{Character. Frequency of calculation, either "monthly" or "seasonal".}

\item{base.range}{Numeric vector. Base range years (default is c(1961, 1990)).}

\item{time.span}{Numeric vector. Time span for output data (default is c(1961, 2022)).}
}
\value{
None. Results are saved to the output directory.
}
\description{
Processes all CSV files in the input directory and outputs the results to the output directory.
}
\examples{
\dontrun{
# Assume we have sea level data 'si' and input/output directories
input_dir <- "path/to/input/csv/files"
output_dir <- "path/to/save/output/files"
# Run the output_all function with monthly frequency
output_all(si, input_dir, output_dir, freq = "monthly")
}
}
