% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{sea_input}
\alias{sea_input}
\title{Sea Level Input Function}
\usage{
sea_input(Date = NULL, Value = NA)
}
\arguments{
\item{Date}{Character vector. Dates in "YYYY-MM" format.}

\item{Value}{Numeric vector. Sea level values (default is NA).}
}
\value{
Data frame with Date and Value columns.
}
\description{
Creates a data frame for sea level data input.
}
\examples{
\donttest{
# 1. Create a monthly sequence from 1960-01 through 2020-12
monthly_seq <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-01"),
  by   = "month"
)

# Convert to "YYYY-MM" format, which sea_input() expects
sea_dates <- format(monthly_seq, "\%Y-\%m")

# 2. Generate random data with an upward linear trend plus some noise
n <- length(sea_dates)
linear_trend <- seq(0, 10, length.out = n)
random_noise <- rnorm(n, mean = 0, sd = 0.3)
sea_values   <- 10 + linear_trend + random_noise  # starts ~10, ends ~20

# 3. Create a sea level data frame with sea_input()
si <- sea_input(Date = sea_dates, Value = sea_values)

# 4. Inspect the first few rows
head(si)
}
}
