% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_getAccHist}
\alias{rp_getAccHist}
\title{Get History}
\usage{
rp_getAccHist(accountId, start = NULL, end = NULL, pageSize = NULL)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{start}{= (Optional) Start timestamp in ISO 8601 format with timezone. Ex. "YYYY-MM-DDTHH:MM:SSZ"}

\item{end}{= (Optional) End timestamp in ISO 8601 format with timezone. Ex. "YYYY-MM-DDTHH:MM:SSZ"}

\item{pageSize}{= (Optional) Maximum number of records to return.}
}
\value{
Fetches a paginated \code{data.frame} of historical events for the specified account.
}
\description{
Get History
}
\examples{
\dontrun{
  # Return Public Brokerage Account History
    my_acc <- rp_getAccts()
    
    # using only accountId
    my_hist <- rp_getAccHist(accountId = my_acc$accountId)
    
    # using some parameters
    my_hist <- rp_getAccHist(accountId = my_acc$accountId, 
                             start = format(Sys.time()-days(30), format="\%Y-\%m-\%dT\%H:\%M:\%SZ"),
                             pageSize = 20
                             )
}
}
