% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcmplot.R
\name{gcmplot}
\alias{gcmplot}
\title{Plot confusion matrix}
\usage{
gcmplot(
  cm,
  colors = c(low = "white", high = "#009194"),
  title = "cm",
  prop = TRUE
)
}
\arguments{
\item{cm}{An confusion matrix object of class "confusionMatrix". Output of the [rTLsDeep::confmatrix_damage()] function.}

\item{colors}{A vector defining the low and high colors. Default is c(low="white", high="#009194").}

\item{title}{A character defining the title of the figure.}

\item{prop}{If TRUE percentage values will be plotted to the figure otherwise Freq.}
}
\value{
Returns an object of class gg and ggplot and plot of the confusion matrix.
}
\description{
This function plots the confusion matrix for classification assessment
}
\examples{

# Path to rds file
rdsfile <- system.file("extdata", "cm_vgg.rds", package="rTLsDeep")

# Read RDS fo;e
cm_vgg<-readRDS(rdsfile)

# Plot confusion matrix
gcmplot_vgg<-gcmplot(cm_vgg,
                    colors=c(low="white", high="#009194"),
                    title="densenet")

}
