% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tephra3D.R
\name{Tephra3d}
\alias{Tephra3d}
\title{Tephra Lagrangian Transport Model}
\usage{
Tephra3d(vx0, vy0, vz0, x0 = 0, y0 = 0, z0 = 0, t0 = 0,
  rho_r = 2000, r = 1, dt = 0.01, Cd = 0.6, verbose = FALSE,
  rho_a = NULL, zt = NULL, wx = 0, wy = 0, wz = 0, mindist = 0,
  TOPO = NULL, Kh = 0, Kz = 0, eddy_timescale = 60, g = 9.80665)
}
\arguments{
\item{vx0}{initial x component of velocity [m/s]}

\item{vy0}{initial y component of velocity [m/s]}

\item{vz0}{initial z component of velocity [m/s]}

\item{x0}{initial easting [m]}

\item{y0}{initial northing [m]}

\item{z0}{initial elevation [m]}

\item{t0}{initial time [s]}

\item{rho_r}{density of tephra particle [kg/m^3]}

\item{r}{rock radius [m]}

\item{dt}{model time interval [s]}

\item{Cd}{drag coefficient [unitless]}

\item{verbose}{logical: print runtime info to screen?}

\item{rho_a}{scalar or function(x,y,z,t) or function(z) giving atmospheric density [kg/m^3]. If NULL, use a variable-density isothermal atmosphere (T = 0 deg C)}

\item{zt}{function(x,y) giving topographic height [m]}

\item{wx}{scalar or function(x,y,z,t) or function(z) giving component of wind to the east [m/s]}

\item{wy}{scalar or function(x,y,z,t) or function(z) giving component of wind to the north [m/s]}

\item{wz}{scalar or function(x,y,z,t) or function(z) giving upward component of wind [m/s]}

\item{mindist}{minimum distance a particle must travel before simulation can stop. This is to prevent early model ends due to spurious collision with crater.}

\item{TOPO}{DEM: list containing vectors x and y and matrix z with dimensions (length(x), length(y))}

\item{Kh}{horizontal eddy diffusivity [m^2/s]}

\item{Kz}{vertical eddy diffusivity (often neglected) [m^2/s]}

\item{eddy_timescale}{1/e decay time of turbulent eddies [s]}

\item{g}{gravitational acceleration [m/s^2]}
}
\description{
This function models the transport of a single particle through a spatially variable, windy, turbulent atmosphere with gravity. It allows 4D-varying atmospheric wind and density. Currently, only Rayleigh drag (low Re) is permitted.
}
\examples{
Tephra3d(vx0 = 40, vy0 = 0, vz0 = 40, z0 = 0)
}
\keyword{misc}
