% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_dimension.R
\name{box_dimension}
\alias{box_dimension}
\title{Box Dimension}
\usage{
box_dimension(cloud, lowercutoff = 0.01, rm_int_box = FALSE, plot = FALSE)
}
\arguments{
\item{cloud}{A point cloud matrix size n x 3.
Non-matrices are automatically converted to a matrix.}

\item{lowercutoff}{The smallest box size determined by the point spacing of
the cloud in meters. Defaults to 1 cm.}

\item{rm_int_box}{Remove the initial box as TRUE or FALSE. Defaults to FALSE.}

\item{plot}{Plot the results. The user can specify "2D", "3D", or "ALL" plots.
FALSE disables plotting. Defaults to FALSE.}
}
\value{
Returns a list
}
\description{
R port of Dominik Seidel's fractal analysis "box-dimension" metric.
}
\examples{
## Calculate Box Dimension
file <- system.file("extdata/cloud.txt", package = "rTwig")
cloud <- read.table(file, header = FALSE)
output <- box_dimension(cloud, plot = "ALL")
output

}
\references{
\insertRef{box_dimension1}{rTwig}

\insertRef{box_dimension2}{rTwig}

\insertRef{box_dimension3}{rTwig}

\insertRef{box_dimension4}{rTwig}

\insertRef{box_dimension5}{rTwig}
}
