% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify_raceland.R
\name{quantify_raceland}
\alias{quantify_raceland}
\title{Quantify a racial landscape}
\usage{
quantify_raceland(
  x,
  n,
  window_size,
  neighbourhood = 4,
  fun,
  size = NULL,
  na_action = "replace",
  base = "log2",
  ordered = TRUE,
  threshold = 0.5
)
}
\arguments{
\item{x}{SpatRaster with race-specific population densities assign to each cell}

\item{n}{A number of realizations}

\item{window_size}{Size, expressed in the number of cells, of a square-shaped local window for which local densities will be calculated; it is recommended to use the small window_size, i.e., 10}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours: \code{4} (rook's case), \code{8} (queen's case). The default is \code{4}.}

\item{fun}{Function to calculate values from adjacent cells to contribute to exposure matrix, \code{"mean"} - calculate average values of local population densities from adjacent cells, \code{"geometric_mean"} - calculate geometric mean values of local population densities from adjacent cells, or \code{"focal"} assign value from the focal cell}

\item{size}{Expressed in the numbers of cells, is a length of the side of a square-shaped block of cells. It defines the extent of a local pattern. If \code{size=NULL} calculations are performed for a whole area}

\item{na_action}{Decides on how to behave in the presence of missing values in \code{w}. Possible options are \code{"replace"}, \code{"omit"}, \code{"keep"}. The default, \code{"replace"}, replaces missing values with 0, \code{"omit"} does not use cells with missing values, and \code{"keep"} keeps missing values.}

\item{base}{The unit in which entropy is measured. The default is "log2", which compute entropy in "bits". \code{"log"} and \code{"log10"} can be also used}

\item{ordered}{The type of pairs considered. Either ordered (\code{TRUE}) or unordered (\code{FALSE}). The default is \code{TRUE}}

\item{threshold}{The share of NA cells to allow metrics calculation in a square-shaped window}
}
\value{
An sf polygon object with five columns - \code{row} and \code{col} allowing for identification of each square polygon, \code{ent} - entropy measuring racial diversity, \code{mutinf} - mutual information, which is associated with measuring racial segregation, and \code{geometry} containing spatial geometries.
}
\description{
This function is a wrapper of several steps (functions) implemented in the raceland package: \code{create_realizations()}, \code{create_densities()}, \code{calculate_metrics()}, and \code{create_grid()}.
}
\examples{
library(terra)
race_raster = rast(system.file("extdata/race_raster.tif", package = "raceland"))
rl = quantify_raceland(race_raster, n = 10, window_size = 10,
 neighbourhood = 4, fun = "mean", size = 20)
}
