% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auction.R
\name{Auction}
\alias{Auction}
\alias{vif}
\alias{runAuction}
\title{Internal function to manage multiple experts.}
\usage{
vif(res, y, X, x, n, p, m, TSS, lmFit)

runAuction(experts, gWealth, theData, y, alg, poly, searchType, m, sigma,
  omega, reuse, nMaxTest, verbose, save, lmFit)
}
\arguments{
\item{res}{residuals from current model.}

\item{y}{the response as a single column matrix.}

\item{X}{covariates in the current model.}

\item{x}{covariate being tested for addition into the model.}

\item{n}{number of observations.}

\item{p}{number of predictors in the \emph{current} model.}

\item{m}{number of observations used in subsampling for variance inflation
factor estimate of r.squared.}

\item{TSS}{total sum of squares; considering current residuals to be the response.}

\item{lmFit}{The core function that will be used to estimate linear model fits.
The default is .lm.fit, but other alternatives are possible. Note that it
does not use formula notation as this is costly. Another recommended option is
fastLmPure from RcppEigen or related packages.}

\item{experts}{list of expert objects. Each expert is the output of
makeStepwiseExpert or makeScavengerExpert.}

\item{gWealth}{global wealth object, output of gWealthStep.}

\item{theData}{covariate matrix.}

\item{alg}{algorithm can be one of "rai", "raiPlus", or "RH" (Revisiting
Holm).}

\item{poly}{logical. Should the algorithm look for higher-order polynomials?}

\item{searchType}{A character string specifying the prioritization of
higher-order polynomials. One of "breadth" (more base features) or "depth"
(higher order).}

\item{sigma}{type of error estimate used in gWealthStep; one of "ind" or "step".}

\item{omega}{return from rejecting a test in Alpha-Investing.}

\item{reuse}{logical. Should repeated tests of the same covariate be
considered a test of the same hypothesis? Reusing wealth isn't implemented
for RAI or RAIplus (effect is negligible).}

\item{nMaxTest}{maximum number of tests}

\item{verbose}{logical. Should auction output be printed?}

\item{save}{logical. Should the auction results be saved? If TRUE, returns a
summary matrix.}
}
\value{
A list which includes the following components: \item{formula}{final
  model formula.} \item{y}{response.} \item{X}{model matrix from final
  model.} \item{features}{list of interactions included in formula.}
  \item{summary}{included if save=TRUE; matrix where each row contains the
  summary information of a single test.}
}
\description{
runAuction is the workhorse of the rai package: it takes an
  initial expert list and runs the Revisiting Alpha-Investing algorithm to
  greedily fit (optional) polynomials and interactions to data.
  The term "auction" is the
  result of multiple experts bidding to perform the test which determines
  stepwise ordering. This function is not intended to be called directly, but
  through \code{\link{rai}}.
}
