% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft2d.R
\name{fft2d}
\alias{fft2d}
\title{Compute spatial Fourier power spectrum}
\usage{
fft2d(z)
}
\arguments{
\item{z}{matrix or array of input data with spatial dimensions \code{c(N, N)}.
If \code{z} is an array the power spectra are averaged over the third dimension.
The first two dimensions must be the same (the input fields must be square).}
}
\value{
Spectral power (average square of absolute value of spectral
amplitudes) for wavenumbers \code{k=1:(N/2)}.
}
\description{
The Fourier power spectrum of the input field is computed and
averaged over shells (bins with width 1) of the modulus of the wavenumber.
}
\examples{
# Make a synthetic rainfall field with prescribed logarithmic spectral slope
f = initmetagauss(1.7, 64)
r = metagauss(f)
# Check slope of the resulting field
fx <- fft2d(r)
fitslope(fx)
# 1.640373
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
