% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rppca.R
\name{randSVD}
\alias{randSVD}
\title{Singular value decomposition in sparse triangular matrix}
\usage{
randSVD(L, rank, depth, numVectors, cent = FALSE)
}
\arguments{
\item{L}{a pedigree's L inverse matrix in sparse 'spam' format}

\item{rank}{An \code{integer}, how many principal components to return}

\item{depth}{\code{integer}, the number of iterations for generating the range matrix}

\item{numVectors}{An \code{integer > rank} to specify the oversampling for the}

\item{cent}{\code{logical}, whether or not to (implicitly) centre the additive
relationship matrix}
}
\value{
A list of three: \code{u} (=U), \code{d} (=Sigma), and \code{v} (=W^T)
}
\description{
Uses randomised linear algebra, see Halko et al. (2010). Singular value
decomposition (SVD) decomposes a matrix \eqn{X=U\Sigma W^T}
}
