% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radsub.R
\name{h_anthropometrics_by_sex}
\alias{h_anthropometrics_by_sex}
\title{Generate Anthropometric Measurements for Males and Females.}
\usage{
h_anthropometrics_by_sex(
  df,
  seed = 1,
  id_var = "USUBJID",
  sex_var = "SEX",
  sex_var_level_male = "M",
  male_weight_in_kg = list(mean = 90.6, sd = 44.9),
  female_weight_in_kg = list(mean = 77.5, sd = 46.2),
  male_height_in_m = list(mean = 1.75, sd = 0.14),
  female_height_in_m = list(mean = 1.61, sd = 0.24)
)
}
\arguments{
\item{df}{(\code{data.frame})\cr Analysis dataset.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{id_var}{(\code{character})\cr Patient identifier variable name.}

\item{sex_var}{(\code{character})\cr Name of variable representing sex of patient.}

\item{sex_var_level_male}{(\code{character})\cr Level of \code{sex_var} representing males.}

\item{male_weight_in_kg}{(named \code{list})\cr List of means and SDs of male weights in kilograms.}

\item{female_weight_in_kg}{(named \code{list})\cr List of means and SDs of female weights in kilograms.}

\item{male_height_in_m}{(named \code{list})\cr List of means and SDs of male heights in metres.}

\item{female_height_in_m}{(named \code{list})\cr list of means and SDs of female heights in metres.}
}
\value{
a dataframe with anthropometric measurements for each subject in analysis dataset.
}
\description{
Anthropometric measurements are randomly generated using normal approximation.
The default mean and standard deviation values used are based on US National Health
Statistics for adults aged 20 years or over. The measurements are generated in same units
as provided to the function.
}
\details{
One record per subject.
}
\keyword{internal}
