% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggvip.R
\name{ggvip}
\alias{ggvip}
\title{Variable Importance GGPlot}
\usage{
ggvip(x, scale = FALSE, sqrt = TRUE, type = "both", num_var)
}
\arguments{
\item{x}{An object of class randomForest.}

\item{scale}{For permutation based measures such as MSE or Accuracy, should
the measures be divided by their "standard errors"? Default is False.}

\item{sqrt}{Boolean value indicating whether importance metrics should be
adjusted via a square root transformation. Default is True.}

\item{type}{either 1 or 2, specifying the type of importance measure
(1=mean decrease in accuracy or % increase in MSE, 2 = mean decrease in
node impurity or mean decrease in gini). Default is "both".}

\item{num_var}{Optional argument for reducing the number of variables to the
top 'num_var'. Must be an integer between 1 and the total number of
predictor variables in the model.}
}
\value{
A ggplot dotchart showing the importance of the variables that were
  plotted.
}
\description{
A ggplot of variable importance as measured by a Random Forest.
}
\examples{
rf <- randomForest::randomForest(factor(Species) ~ .,
  importance = TRUE,
  data = iris
)
ggvip(rf, scale = FALSE, sqrt = TRUE, type = "both")
}
