% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomGODB.R
\name{hitters}
\alias{hitters}
\title{hitters}
\usage{
hitters(
  GOGOA3,
  ontology,
  hitters,
  ngene,
  GOBPCHILDREN,
  GOBPANCESTOR,
  verbose = TRUE
)
}
\arguments{
\item{GOGOA3}{return value of minimalistGODB::buildGODatabase()}

\item{ontology}{character c("biological_process","molecular_function","cellular_component")}

\item{hitters}{character c("big","mid","lo","all") designate which portion of gene table to look at}

\item{ngene}{integer number of genes to examine within range of 'hitters'}

\item{GOBPCHILDREN}{GO.db data set}

\item{GOBPANCESTOR}{GO.db data set}

\item{verbose}{Boolean if TRUE print out some information}
}
\value{
returns no values, but has side effect of printing out some information
}
\description{
pick genes of a size range and submit to fractAncest()
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# This example is given in full detail in the package vignette.
# You can generate GOGOA3.RData using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/databases
dir<-"/Users/barryzeeberg/personal/GODB_RDATA/goa_human/"
load(sprintf("\%s/\%s",dir,"GOGOA3_goa_human.RData"))
hitters(GOGOA3,ontology="biological_process",hitters="all",
 5,GO.db::GOBPCHILDREN,GO.db::GOBPANCESTOR)
}

}
