% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_rang.R
\name{create_turing}
\alias{create_turing}
\title{Create executable research compendium according to the Turing Way}
\usage{
create_turing(
  path,
  add_rang = TRUE,
  add_makefile = TRUE,
  add_here = TRUE,
  verbose = TRUE,
  force = FALSE,
  apptainer = FALSE
)
}
\arguments{
\item{path}{character, path to the project root}

\item{add_rang}{logical, whether to run \code{\link[=use_rang]{use_rang()}} to \code{path}}

\item{add_makefile}{logical, whether to insert a barebone \code{Makefile} in the project root.}

\item{add_here}{logical, whether to insert a hidden \code{.here} file in the project root}

\item{verbose}{logical, whether to print out messages}

\item{force}{logical, whether to overwrite files (\code{inst/rang/update.R}, \code{Makefile}, \code{.here}) if they
exist.}

\item{apptainer}{logical, whether to use apptainer. \code{FALSE} indicates using Docker}
}
\value{
path, invisibly
}
\description{
This \code{usethis}-style function creates an executable research compendium according to the Turing Way.
}
\details{
According to the Turing Way, an executable research compendium should have the following properties
\enumerate{
\item Files should be organized in a conventional folder structure;
\item Data, methods, and output should be clearly separated;
\item The computational environment should be specified.
}

We use the structure suggested by the Turing Way:
\itemize{
\item \code{data_raw}: a directory to hold the raw data
\item \code{data_clean}: a directory to hold the processed data
\item \code{code}: a directory to hold computer code
\item \code{CITATION}: a file holding citation information
\item \code{paper.Rmd}: a manuscript
This function provides the a clearly separated organizational structure. Components can be changed. For example, the manuscript can be in another format (e.g. quarto, sweave) or even optional. With \code{add_rang}, the computational environment can be recorded and reconstructed later.
}
}
\references{
\href{https://the-turing-way.netlify.app/reproducible-research/compendia.html}{The Turing Way: Research Compendia}
Gorman, KB, Williams TD. and Fraser WR (2014). Ecological Sexual Dimorphism and Environmental Variability within a Community of Antarctic Penguins (Genus Pygoscelis). PLoS ONE 9(3):e90081. \doi{10.1371/journal.pone.0090081}
}
\seealso{
\code{\link[=use_rang]{use_rang()}}
}
