% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmb.R
\name{dmb}
\alias{dmb}
\title{Calculate the density of rankings and ratings under a Mallows-Binomial distribution.}
\usage{
dmb(rankings, ratings, p, theta, M, pi0 = NULL, log = FALSE)
}
\arguments{
\item{rankings}{A matrix of rankings, potentially with attribute "assignments" to signify separate
reviewer assignments. One ranking per row.}

\item{ratings}{A matrix of ratings, one row per judge and one column per object.}

\item{p}{A vector specifying the underlying object qualities. All values between be between 0 and 1, inclusive.}

\item{theta}{A numeric entry specifying the Mallows scale parameter.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{pi0}{A vector specifying the consensus (modal probability) ranking; should be used only for tie-breaking
equal values in \code{p}.}

\item{log}{A boolean indicating if the log likelihood should be returned.}
}
\value{
A numeric value indicating the (log) likelihood of rankings and ratings under a Mallows distribution.
}
\description{
This function calculates the density of observation(s) under a Mallows-Binomial distribution.
}
\examples{
data(ToyData1)
dmb(rankings=ToyData1$rankings,ratings=ToyData1$ratings,p=c(.2,.5,.7),theta=1,M=ToyData1$M)
dmb(rankings=ToyData1$rankings,ratings=ToyData1$ratings,p=c(.25,.25,.7),theta=1,M=ToyData1$M,
pi0=c(1,2,3),log=TRUE)

}
