% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raptools.R
\name{ggcalibrate_original}
\alias{ggcalibrate_original}
\title{The Original Calibration plot}
\usage{
ggcalibrate_original(
  x1,
  x2 = NULL,
  y = NULL,
  n_cut = 5,
  cut_type = c("interval", "number", "width"),
  include_margin = FALSE
)
}
\arguments{
\item{x1}{Either a logistic regression fitted using glm (base package) or lrm (rms package) or calculated probabilities (eg through a logistic regression model) of the baseline model.  Must be between 0 & 1}

\item{x2}{Either a logistic regression fitted using glm (base package) or lrm (rms package) or calculated probabilities (eg through a logistic regression model) of the new (alternative) model.   Must be between 0 & 1}

\item{y}{Binary of outcome of interest. Must be 0 or 1 (if fitted models are provided this is extracted from the fit which for an rms fit must have x = TRUE, y = TRUE).}

\item{n_cut}{An integer indicating either the number of intervals of the same width, the number of intervals of the same number of subjects, or the width (as a percentage) of the intervals.}

\item{cut_type}{One of three strings: "interval", "number", or "width". 
- "interval": uses cut_interval() to get n_cut intervals of approximately equal width.
- "number": uses cut_number() to get n_cut intervals with approximately equal counts.
- "width": uses cut_width() to get intervals of a fixed width (approximately 100/n_cut).}

\item{include_margin}{TRUE for including producing a bar plot of the counts of in each of the intervals. Default is FALSE.  Note if the output is saved to my_graphs then using the library gridExtra the function grid.arrange(graphs$g, graphs$g_marg , nrow = 2, heights = c(2,1)) will produce a plot with both the calibration plot and the marginal plot.}
}
\value{
a list of one or two ggplots
}
\description{
ggcalibrate_original plots the stats::predicted events against the actual event rate using the "old" form.
}
\examples{
# Quick example with subset of data
data(data_risk)
data_subset <- data_risk[1:100, ]  # Use first 100 rows for speed
complete_cases <- complete.cases(data_subset)
data_clean <- data_subset[complete_cases, ]
y <- data_clean$outcome 
x1 <- data_clean$baseline
x2 <- data_clean$new
output <- ggcalibrate_original(
  x1, x2, y,
  n_cut = 3, cut_type = "interval",
  include_margin = FALSE
)

\donttest{
# Full dataset example
data(data_risk)
complete_cases <- complete.cases(data_risk)
data_clean <- data_risk[complete_cases, ]
y <- data_clean$outcome 
x1 <- data_clean$baseline
x2 <- data_clean$new
output <- ggcalibrate_original(
  x1, x2, y,
  n_cut = 5, cut_type = "interval",
  include_margin = FALSE
)
}
}
