% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{raster,RasterList-method}
\alias{raster,RasterList-method}
\alias{raster}
\title{\code{Raster} methods for a \code{\link{RasterList-class}} object.}
\usage{
\S4method{raster}{RasterList}(x, FUN = NULL, ...)
}
\arguments{
\item{x}{a valid \code{\link{RasterList-class}} object}

\item{FUN}{if it not \code{NULL} a function is applied to all elements of the \code{list} slot in \code{x}.}

\item{...}{further arguments}
}
\value{
a \code{\link[raster]{RasterLayer-class}} object
}
\description{
\code{Raster} methods for a \code{\link{RasterList-class}} object.
}
\examples{

f <- system.file("external/test.grd", package="raster")
ur <- rasterList(raster(f),FUN=function(x,d){x+0:d},d=10)

r1 <- raster(ur)
r2 <- raster(ur,FUN=function(x){x[2]})

}
\seealso{
\code{\link{stack}},\code{\link{RasterListApply}}
}
