% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairbinci.R
\name{pairbinci}
\alias{pairbinci}
\title{Confidence intervals for comparisons of paired binomial rates.}
\usage{
pairbinci(
  x,
  level = 0.95,
  contrast = "RD",
  method = ifelse(contrast == "OR", "SCASp", "Score"),
  moverbase = ifelse(method \%in\% c("MOVER", "MOVER_newc", "BP"), "jeff", NULL),
  bcf = TRUE,
  skew = TRUE,
  cc = FALSE,
  theta0 = NULL,
  precis = 6,
  warn = TRUE,
  method_RD = NULL,
  method_RR = NULL,
  method_OR = NULL,
  cctype = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector object specified as c(a, b, c, d)
where: \cr
a is the number of pairs with the event (e.g. success) under both
conditions (e.g. treated/untreated, or case/control) \cr
b is the count of the number with the event on condition 1 only (= x12) \cr
c is the count of the number with the event on condition 2 only (= x21) \cr
d is the number of pairs with no event under both conditions \cr
(Note the order of a and d is only important for contrast="RR".)}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{contrast}{Character string indicating the contrast of interest: \cr
"RD" = rate difference (default); \cr
"RR" = rate ratio; \cr
"OR" = conditional odds ratio.}

\item{method}{Character string indicating the confidence interval method
to be used. The following are available for \code{contrast = "RD"} or \code{"RR"}: \cr
"Score" = (default) asymptotic score class of methods including Tango
(for RD) / Tang (for RR), by iterative calculations, with
optional skewness correction; \cr
"Score_closed" = closed form solution for Tango/Tang intervals
(without skewness correction); \cr
"MOVER" = hybrid MOVER method (as per "method 8" in Newcombe, but with
a choice of input methods - see moverbase); \cr
"MOVER_newc" = hybrid MOVER methods with correction to correlation
estimate (Newcombe's "method 10"); \cr
"TDAS" = t-distribution asymptotic score (experimental method, now
deprecated); \cr
"BP" = Wald with Bonett-Price adjustment for RD, or Hybrid Bonett-Price
method for RR. \cr
For \code{contrast = "OR"}, one of the following methods may be selected,
all of which are based on transformation of an interval for a single
proportion \code{b/(b+c)}: \cr
"SCASp" = transformed skewness-corrected score (default); \cr
"jeff" = transformed Jeffreys; \cr
"midp" = transformed mid-p; \cr
"wilson" = transformed Wilson score - included for reference only, not
recommended.}

\item{moverbase}{Character string indicating the base method used as input
for the MOVER methods for RD or RR (when method = "MOVER" or "MOVER_newc"),
and for the Hybrid BP method for RR:
"jeff" = Jeffreys equal-tailed interval (default),
"SCASp" = skewness-corrected score,
"midp" = mid-p,
"wilson" = Wilson score (not recommended, known to be skewed).}

\item{bcf}{Logical (default FALSE) indicating whether to apply variance bias
correction in the score denominator. (Under evaluation, manuscript under
review.)}

\item{skew}{Logical (default TRUE) indicating whether to apply skewness
correction or not. (Under evaluation, manuscript under review.)
\itemize{
\item Only applies for the iterative \code{method = "Score"}.
}}

\item{cc}{Number or logical (default FALSE) specifying (amount of) continuity
adjustment. When a score-based method is used, cc = 0.5 corresponds to the
continuity-corrected McNemar test.}

\item{theta0}{Number to be used in a one-sided significance test (e.g.
non-inferiority margin). 1-sided p-value will be < 0.025 iff 2-sided 95\\% CI
excludes theta0. NB: can also be used for a superiority test by setting
theta0 = 0.}

\item{precis}{Number (default 6) specifying precision (i.e. number of decimal
places) to be used in optimisation subroutine for the confidence interval.}

\item{warn}{Logical (default TRUE) giving the option to suppress warnings.}

\item{method_RD}{(deprecated: parameter renamed to method)}

\item{method_RR}{(deprecated: parameter renamed to method)}

\item{method_OR}{(deprecated: parameter renamed to method)}

\item{cctype}{(deprecated: new equivariant cc method implemented instead.)}

\item{...}{Other arguments.}
}
\value{
A list containing the following components: \describe{
\item{data}{the input data in 2x2 matrix form.}
\item{estimates}{the requested contrast, with its confidence interval and
the specified confidence level, along with estimates of the marginal
probabilities and the correlation coefficient (uncorrected and
corrected).}
\item{pval}{the corresponding 2-sided significance test
against the null hypothesis that p_1 = p_2, and one-sided
significance tests against the null hypothesis that theta >= or <= theta0
as specified.}
\item{call}{details of the function call.}}
}
\description{
Confidence intervals for the rate (or risk) difference ("RD"), rate ratio
("RR") or conditional odds ratio ("OR"), for paired binomial data. (For
paired Poisson rates, suggest use the tdasci function with \code{distrib = "poi"},
and \code{weighting = "MH"}, with pairs as strata.)
This function applies the score-based Tango and Tang methods for RD and
RR respectively, with iterative and closed-form versions, and an added
skewness correction for improved one-sided coverage.
Also includes MOVER options using the Method of Variance Estimates Recovery
for paired RD and RR, incorporating Newcombe's correlation correction, and
some simpler methods by Bonett & Price for RD and RR.
For OR, intervals are produced based on transforming various intervals for
the single proportion, including SCASp, mid-p and Jeffreys.
All methods have options for continuity adjustment, and the magnitude of
adjustment can be customised.
}
\examples{
# Example from Fagerland et al 2014
# SCAS method for RD
pairbinci(x = c(1, 1, 7, 12), contrast = "RD", method = "Score")
# Tango method
pairbinci(x = c(1, 1, 7, 12), contrast = "RD", method = "Score", skew = FALSE, bcf = FALSE)
# MOVER-NJ method
pairbinci(x = c(1, 1, 7, 12), contrast = "RD", method = "MOVER_newc", moverbase = "jeff")
# SCAS for RR
pairbinci(x = c(1, 1, 7, 12), contrast = "RR", method = "Score")
# Tang method
pairbinci(x = c(1, 1, 7, 12), contrast = "RR", method = "Score", skew = FALSE, bcf = FALSE)
# MOVER-NJ
pairbinci(x = c(1, 1, 7, 12), contrast = "RR", method = "MOVER_newc", moverbase = "jeff")
# Transformed SCASp method for OR
pairbinci(x = c(1, 1, 7, 12), contrast = "OR", method = "SCASp")
# Transformed Wilson method
pairbinci(x = c(1, 1, 7, 12), contrast = "OR", method = "wilson")

}
\references{
Tango T. Equivalence test and confidence interval for the difference
in proportions for the paired-sample design.
Statistics in Medicine 1998; 17:891-908

Newcombe RG. Improved confidence intervals for the difference between
binomial proportions based on paired data.
Statistics in Medicine 1998; 17:2635-2650

Tango T. Improved confidence intervals for the difference between binomial
proportions based on paired data by Robert G. Newcombe, Statistics in
Medicine, 17, 2635-2650 (1998).
Statistics in Medicine 1999; 18(24):3511-3513

Nam J-M, Blackwelder WC. Analysis of the ratio of marginal
probabilities in a matched-pair setting.
Stat Med 2002; 21(5):689–699

Tang N-S, Tang M-L, Chan ISF. On tests of equivalence via non-unity
relative risk for matched-pair design.
Statistics in Medicine 2003; 22:1217-1233

Agresti A, Min Y. Simple improved confidence intervals for
comparing matched proportions.
Statistics in Medicine 2005; 24:729-740

Bonett DG, Price RM. Confidence intervals for a ratio of binomial
proportions based on paired data.
Statistics in Medicine 2006; 25:3039-3047

Tang M-L, Li H-Q, Tang N-S. Confidence interval construction for proportion
ratio in paired studies based on hybrid method.
Statistical Methods in Medical Research 2010; 21(4):361-378

Tang N-S et al. Asymptotic confidence interval construction for proportion
difference in medical studies with bilateral data.
Statistical Methods in Medical Research. 2011; 20(3):233-259

Yang Z, Sun X and Hardin JW. A non-iterative implementation of Tango's
score confidence interval for a paired difference of proportions.
Statistics in Medicine 2013; 32:1336-1342

Fagerland MW, Lydersen S, Laake P. Recommended tests and
confidence intervals for paired binomial proportions.
Statistics in Medicine 2014; 33(16):2850-2875

Laud PJ. Equal-tailed confidence intervals for comparison of rates.
Pharmaceutical Statistics 2017; 16:334-348.

DelRocco N et al. New Confidence Intervals for Relative Risk of Two
Correlated Proportions.
Statistics in Biosciences 2023; 15:1–30

Chang P et al. Continuity corrected score confidence interval for the
difference in proportions in paired data.
Journal of Applied Statistics 2024; 51-1:139-152

Laud PJ. Comments on "New Confidence Intervals for Relative Risk of Two
Correlated Proportions" (2023).
Statistics in Biosciences 2025; https://doi.org/10.1007/s12561-025-09479-4

Laud PJ. Improved confidence intervals and tests for paired binomial
proportions. (2025, Under review)
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
