% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-dcm2niix.R
\name{cmd_run_dcm2niix}
\alias{cmd_run_dcm2niix}
\title{Convert DICOM to NIfTI via \code{'dcm2niix'}}
\usage{
cmd_run_dcm2niix(
  subject,
  src_path,
  type = c("MRI", "CT"),
  merge = c("Auto", "No", "Yes"),
  float = c("Yes", "No"),
  crop = c("No", "Yes", "Ignore"),
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)
}
\arguments{
\item{subject}{'RAVE' subject or a subject ID}

\item{src_path}{source directory}

\item{type}{image type}

\item{merge, float, crop}{\code{'dcm2niix'} parameters}

\item{overwrite}{overwrite existing files}

\item{command_path}{path to program \code{'dcm2niix'}}

\item{dry_run}{whether to dry-run}

\item{verbose}{whether to print out command}
}
\value{
A command set running the terminal command; a folder named with
\code{type} will be created under the subject image input folder
}
\description{
Check \url{https://rave.wiki} on how to set up \code{'conda'} environment
for 'RAVE' using \code{'ravemanager'}.
}
\examples{

\dontrun{

cmd_run_dcm2niix(
  "YAEL/pt02",
  "/path/to/DICOMDIR",
  "MRI"
)

}

}
